
import parser.*;
import parser.visitor.*;

import token.*;
import token.tokenizer.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.util.*;


public class RDPFrame extends JFrame {
  private static final long serialVersionUID = 2007111140354L;
  /**
   * Content pane.
   */
  private JPanel contentPane;
  
  /**
   * Output text area.
   */
  private JTextArea outputTA = new JTextArea();
  
  /**
   * Top panel.
   */
  private JPanel topPanel = new JPanel();
  
  /**
   * Bottom scroll pane.
   */
  private JScrollPane scrollPane = new JScrollPane();
  
  /**
   * File name input field.
   */
  private JTextField inpFileTF = new JTextField();

  /**
   * File name input field.
   */
  private JTextField inpFile2TF = new JTextField();
  
  /**
   * Button to parse original grammar file.
   */
  private JButton parseOrigBtn = new JButton();
  
  /**
   * Button to parse XML file.
   */
  private JButton parseXMLBtn = new JButton();
  
  /**
   * Button to semantically check the parsed file.
   */
  private JButton checkBtn = new JButton();

  /**
   * Button to parse BNF file.
   */
  private JButton parseBNFBtn = new JButton();
  
  /**
   * Button to semantically check the parsed BNF file.
   */
  private JButton checkBNFBtn = new JButton();

  private JComboBox tokCBx = new JComboBox(new String[]{"Tokenizer1", "XMLTokenizer", "BNFTokenizer"});
  
  
  /**
   * Tokenizer.
   */
  private ITokenizer tok;
  
  /**
   * Constructor for the frame.
   */
  public RDPFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  /**
   * Initialize GUI components.
   */
  private void jbInit() {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(RDPFrame.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(new BorderLayout());
    
    this.setSize(new Dimension(800, 400));
    this.setTitle("YAK (Yet Another Kooprey)");
    
    inpFileTF.setMinimumSize(new Dimension(100, 21));
    inpFileTF.setPreferredSize(new Dimension(100, 21));
    inpFileTF.setText("bnf1.txt");

    inpFile2TF.setMinimumSize(new Dimension(100, 21));
    inpFile2TF.setPreferredSize(new Dimension(100, 21));
    inpFile2TF.setText("input1.txt");
    
    parseOrigBtn.setText("Parse Orig");
    parseOrigBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        parseOrigBtn_actionPerformed(e);
      }
    });
    
    parseXMLBtn.setText("Parse XML");
    parseXMLBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        parseXMLBtn_actionPerformed(e);
      }
    });
    
    checkBtn.setText("Check XML result");
    checkBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        checkBtn_actionPerformed(e);
      }
    });
    
    parseBNFBtn.setText("Parse BNF");
    parseBNFBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        parseBNFBtn_actionPerformed(e);
      }
    });

    checkBNFBtn.setText("Check BNF");
    checkBNFBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        checkBNFBtn_actionPerformed(e);
      }
    });

    topPanel.add(inpFileTF, null);
    topPanel.add(parseOrigBtn, null);
    topPanel.add(parseXMLBtn, null);
    topPanel.add(checkBtn, null);
    topPanel.add(parseBNFBtn, null);
    topPanel.add(checkBNFBtn, null);
    topPanel.add(tokCBx, null);
    topPanel.add(inpFile2TF, null);
    
    contentPane.add(scrollPane, BorderLayout.CENTER);
    contentPane.add(topPanel, BorderLayout.NORTH);
    scrollPane.getViewport().add(outputTA, null);
  }
  
  /**
   * Overridden so we can exit when window is closed.
   *
   * @param e window event
   */
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }
  
  /**
   * Make original grammar parser.
   *  
   *  E ::= F E1
   *  F ::= F1 | F2
   *  F1 ::= NumToken
   *  F2 ::= IdToken
   *  E1 ::= E1a | Empty
   *  E1a ::= + E
   * 
   * @throws FileNotFoundException thrown if file is not found
   */
  protected ITokVisitorFact makeOrigParser() throws FileNotFoundException {
    tok = new Tokenizer1(inpFileTF.getText());
        
    ProxyFact eFact_Proxy = new ProxyFact(); // use this wherever E appears in the grammar, except the very beginning.
    
    ITokVisitorFact eFact = new SequenceFact("E", tok,
                                                  new CombinationFact("F", tok, 
                                                                      new TerminalSymbolFact("Num", tok), 
                                                                      new TerminalSymbolFact("Id", tok)),
                                                  new CombinationFact("E1", tok, 
                                                                      new SequenceFact("E1a", tok, 
                                                                                            new TerminalSymbolFact("\"+\"", tok), 
                                                                                            eFact_Proxy), 
                                                                      new MTSymbolFact(tok)));
    
    eFact_Proxy.setFact(eFact);  // close the loop
    
    
    System.err.println("Parser Factory = " + eFact);
    
    return eFact;
  }
  
  /**
   * Parse file.
   *
   * @param e action event
   */
  void parseOrigBtn_actionPerformed(ActionEvent e) {
    try {
      ITokVisitorFact origParseFact = makeOrigParser();
      outputTA.append("parserFact = \n"+origParseFact+"\n");
      
      ITokVisitor<IGrammarSymbol, Object> parser = origParseFact.makeVisitor();
      System.err.println("Parser visitor = " + parser);
      
      result = tok.getNextToken().execute(parser);
      System.err.println("Result = " + result);
      
      outputTA.append(result.toString());
    }
    catch (Exception e1) {
      StringBuffer sb = new StringBuffer();
      sb.append(e1.toString());
      sb.append('\n');
      StackTraceElement[] ste = e1.getStackTrace();
      for (int i = 0; i < ste.length; ++i) {
        sb.append('\t');
        sb.append(ste[i].toString());
        sb.append('\n');
      }
      outputTA.setText(sb.toString());
      outputTA.setCaretPosition(0);
      e1.printStackTrace();
    }
  }
  
  /**
   * Make XML parser.
   *
   * TaggedElt ::= < Id > AXML </ Id > 
   * AXML  ::=  NEXML | MTSymbol   
   * NEXML ::=  AElement AXML 
   * AElement ::=  Id | TaggedElt 
   * 
   * Notes:
   * MTSymbol = empty token
   * "</" is a single token above, not two tokens
   * 
   * @throws FileNotFoundException thrown if file is not found
   */
  protected ITokVisitorFact makeXMLParser() throws FileNotFoundException {
    tok = new XMLTokenizer(inpFileTF.getText());  
    
    ITokVisitorFact leftBracketFact = new TerminalSymbolFact("\"<\"", tok);
    ITokVisitorFact rightBracketFact = new TerminalSymbolFact("\">\"", tok);
    ITokVisitorFact forwardSlashFact = new TerminalSymbolFact("\"/\"", tok);
    ITokVisitorFact idFact = new TerminalSymbolFact("Id", tok);
    ITokVisitorFact leftBracketForwardSlashFact = new TerminalSymbolFact("\"</\"", tok);
        
    ProxyFact taggedElt_Proxy = new ProxyFact();
    
    ProxyFact aXML_Proxy = new ProxyFact();
    
    ITokVisitorFact aXML = new CombinationFact("AXML", tok,
                                               new MultiSequenceFact("NEXML", tok,
                                                                     new CombinationFact("AElement", tok,
                                                                                         idFact, taggedElt_Proxy),
                                                                     aXML_Proxy), 
                                               new MTSymbolFact(tok));
    aXML_Proxy.setFact(aXML);
    
    ITokVisitorFact taggedElt = new MultiSequenceFact("EFac", tok,
                                                      leftBracketFact, idFact, rightBracketFact,
                                                      aXML, 
                                                      leftBracketForwardSlashFact, idFact, rightBracketFact);
    
    taggedElt_Proxy.setFact(taggedElt);
    
    System.err.println("Parser Factory = " + taggedElt);
    
    return taggedElt;
  }
  
  IGrammarSymbol result;
  
  /**
   * Parse file.
   *
   * @param e action event
   */
  void parseXMLBtn_actionPerformed(ActionEvent e) {
    try {
      ITokVisitorFact xmlParseFact = makeXMLParser();
      
      ITokVisitor<IGrammarSymbol, Object> parser = xmlParseFact.makeVisitor();
      System.err.println("Parser visitor = " + parser);
      
      result = tok.getNextToken().execute(parser);
      System.err.println("Result = " + result);
      
      outputTA.setText(result.toString());
    }
    catch (Exception e1) {
      StringBuffer sb = new StringBuffer();
      sb.append(e1.toString());
      sb.append('\n');
      StackTraceElement[] ste = e1.getStackTrace();
      for (int i = 0; i < ste.length; ++i) {
        sb.append('\t');
        sb.append(ste[i].toString());
        sb.append('\n');
      }
      outputTA.setText(sb.toString());
      outputTA.setCaretPosition(0);
      e1.printStackTrace();
    }
  }
  
  void checkBtn_actionPerformed(ActionEvent e) {
    System.out.println("Checking XML on result = "+result);
    boolean isOk = result.execute(CheckMatchingTagsAlgo.Singleton);
    outputTA.append("\n"+"Check result: "+ isOk);
  }
  
  
  /**
   * BNF of BNF
   * 
   * S   ::= D | S1
   * S1  ::= lf S
   * D   ::=  WordToken "::=" E L
   * 
   * L   ::=  L2 | Empty
   * L2  ::=  lf  L3
   * L3  ::=  L | D
   * 
   * E   ::=  T E1
   * E1  ::=  Empty | E1a
   * E1a ::=  "|" E
   * 
   * T   ::= T1 T2
   * T1  ::= WordToken| QuotedStringToken
   * T2  ::= Empty | T
   * 
   * Creates a parser for BNF by hard-coding the above grammar.  
   * Returns the factory for the start symbol, S.
   */
  public ITokVisitorFact makeBNFParser()  throws FileNotFoundException {
    tok = new BNFTokenizer(inpFileTF.getText());  
    // STUDENT TO COMPLETE
    
    return null;  // Stub code
  }

  IGrammarSymbol bnfResult;
  
  void parseBNFBtn_actionPerformed(ActionEvent e) {
    try {
      ITokVisitorFact bnfParseFact = makeBNFParser();

      outputTA.setText("bnfParseFact = \n"+bnfParseFact+"\n");
      
      ITokVisitor<IGrammarSymbol, Object> parser = bnfParseFact.makeVisitor();
      System.err.println("Parser visitor = " + parser);
      
      bnfResult = tok.getNextToken().execute(parser);
      System.err.println("Result = \n" + bnfResult);
      
      outputTA.append(bnfResult.toString()+"\n");
    }
    catch (Exception e1) {
      StringBuffer sb = new StringBuffer();
      sb.append(e1.toString());
      sb.append('\n');
      StackTraceElement[] ste = e1.getStackTrace();
      for (int i = 0; i < ste.length; ++i) {
        sb.append('\t');
        sb.append(ste[i].toString());
        sb.append('\n');
      }
      outputTA.setText(sb.toString()+"\n");
      outputTA.setCaretPosition(0);
      e1.printStackTrace();
    }
  }

  /**
   * Finds all the non-terminals in the parsed BNF 
   * Then creates a parser visitor factory and runs it on 
   * the file specified in inpFile2TF using the selected tokenizer.
   */
  void checkBNFBtn_actionPerformed(ActionEvent e) {
    IGramSymVisitor<Map<String,IGrammarSymbol>, Object> findNonTermsAlgo = new parser.bnf.FindNonTerminalsAlgo();
    
    Map<String,IGrammarSymbol> nonTerminalsMap = bnfResult.execute(findNonTermsAlgo);
    
    outputTA.append("\nNon-Terminal Symbols: ");
    
    for(Map.Entry<String, IGrammarSymbol> entry : nonTerminalsMap.entrySet()) {
      outputTA.append(entry.getValue()+" ");
    }
    outputTA.append("\n");
  
    // COMMENT OUT THE REST OF THIS METHOD WHEN TESTING
    // FindNonTerminalsAlgo
    try {
      ITokenizer tok2 = (ITokenizer) Class.forName("token.tokenizer."+tokCBx.getSelectedItem()).getConstructor(Class.forName("java.lang.String")).newInstance(inpFile2TF.getText());
      //ITokenizer tok2 = new Tokenizer1(inpFile2TF.getText());
      ITokVisitorFact parserFact = bnfResult.execute(new parser.bnf.MakeParserFactAlgo(tok2, nonTerminalsMap));
      outputTA.append("parserFact = \n"+parserFact+"\n");
      ITokVisitor<IGrammarSymbol, Object> parser = parserFact.makeVisitor();
      result = tok2.getNextToken().execute(parser);
      System.err.println("Result = \n" + result);
      
      outputTA.append(result.toString()+"\n");
    }
    catch(Exception expt) {
      System.err.println("checkBNFBtn_actionPerformed:  Exception = "+expt);
      expt.printStackTrace();
    }
  }
  
}